---
Difficulty: Medium
Source: Daily-Question(POTD 23-Nov)
Tags:
    - Array
    - Two Pointers
    - Matrix
---

# 🚀 *1861 - Rotating the Box* 🧠

### Problem Link:
[**LeetCode - Rotating the Box**](https://leetcode.com/problems/rotating-the-box/?envType=daily-question&envId=2024-11-23)


## 💡 **Problem Breakdown:**

You are given an `m x n` grid representing a box. Each cell of the grid contains one of three characters:
- `'#'` (a stone),
- `'*'` (an obstacle), or
- `'.'` (an empty space).

The box is rotated 90 degrees clockwise. Before rotation, the stones fall to the lowest possible positions due to gravity, i.e., stones move downward until obstructed by an obstacle or another stone.


## 🔍 **Example Walkthrough:**

### Example 1:
<img src="https://github.com/user-attachments/assets/2be2fa73-6f50-4c70-a287-1e408131ce45" width="35%">

**Input:**  
`box = [["#",".","#"]]`  
**Output:**  
`[["."],["#"],["#"]]` 

**Explanation:**  
- After gravity, the stones in the box fall to the bottom.  
- After rotating the box, the stones appear stacked in a single column.

### Example 2:
<img src="https://github.com/user-attachments/assets/f6e78b05-6b24-4fb6-8152-b17c13303fe7" width="40%">



**Input:**  
`box = [["#",".","*","."],["#","#","*","."]]`  
**Output:**  
`[["#","."],["#","#"],["*","*"],[".","."]]`  

**Explanation:**  
- Stones first fall to the bottom.  
- The box is then rotated 90 degrees clockwise.  
         
### Example 3:
<img src="https://github.com/user-attachments/assets/101a4453-99a9-4de4-be13-4abfac9a3642" width="45%">


**Input:**  
`box = [["#","#","*",".","*","."],["#","#","#","*",".","."],["#","#","#",".","#","."]]`  
**Output:**  
`[[".","#","#"],[".","#","#"],["#","#","*"],["#","*","."],["#",".","*"],["#",".","."]]`  

### Constraints:

- `m == box.length`
- `n == box[i].length`
- `1 <= m, n <= 500`
- `box[i][j] is either '#', '*', or '.'.`


## 🎯 **My Approach:**

1. **Gravity Simulation:** 
   - For each row, let stones (`'#'`) fall to the lowest possible position, stopping when they hit obstacles (`'*'`) or another stone.

2. **Rotation:**
   - Rotate the box 90 degrees clockwise by creating a new grid where the rows of the original grid become the columns of the rotated grid.

3. **Implementation Steps:**
   - Traverse the grid row by row, applying gravity for each row.
   - Create the rotated grid by transposing and flipping the rows.


## 🕒 **Time Complexity:**
- **O(m × n):**  
  - Gravity simulation and rotation both iterate over all cells in the grid.
- **Space Complexity:**  
  - **O(m × n):** New grid is allocated for the rotated result.


## 📝 **Solution Code**

## **C Code:**

```c
char** rotateTheBox(char** box, int boxSize, int* boxColSize, int* returnSize, int** returnColumnSizes) {
    int rows = boxSize;
    int cols = *boxColSize;

    char** result = (char**)malloc(cols * sizeof(char*));
    *returnColumnSizes = (int*)malloc(cols * sizeof(int));
    for (int i = 0; i < cols; i++) {
        result[i] = (char*)malloc(rows * sizeof(char));
        (*returnColumnSizes)[i] = rows;
    }

    for (int i = 0; i < rows; i++) {
        int empty_spot = cols - 1;
        for (int j = cols - 1; j >= 0; j--) {
            if (box[i][j] == '#') {
                box[i][j] = '.';
                box[i][empty_spot--] = '#';
            } else if (box[i][j] == '*') {
                empty_spot = j - 1;
            }
        }
        for (int j = 0; j < cols; j++) {
            result[j][rows - 1 - i] = box[i][j];
        }
    }

    *returnSize = cols;
    return result;
}
```



## **C++ Code:**

```cpp
class Solution {
public:
    vector<vector<char>> rotateTheBox(vector<vector<char>>& box) {
        int rows = box.size();
        int cols = box[0].size();
        vector<vector<char>> result(cols, vector<char>(rows, '.'));

        for (int i = 0; i < rows; i++) {
            int empty_spot = cols - 1;
            for (int j = cols - 1; j >= 0; j--) {
                if (box[i][j] == '#') {
                    box[i][j] = '.';
                    box[i][empty_spot--] = '#';
                } else if (box[i][j] == '*') {
                    empty_spot = j - 1;
                }
            }
            for (int j = 0; j < cols; j++) {
                result[j][rows - 1 - i] = box[i][j];
            }
        }

        return result;
    }
};
```



## **Java Code:**

```java
class Solution {
    public char[][] rotateTheBox(char[][] box) {
        int rows = box.length;
        int cols = box[0].length;
        char[][] result = new char[cols][rows];

        for (int i = 0; i < rows; i++) {
            int emptySpot = cols - 1;
            for (int j = cols - 1; j >= 0; j--) {
                if (box[i][j] == '#') {
                    box[i][j] = '.';
                    box[i][emptySpot--] = '#';
                } else if (box[i][j] == '*') {
                    emptySpot = j - 1;
                }
            }
            for (int j = 0; j < cols; j++) {
                result[j][rows - 1 - i] = box[i][j];
            }
        }

        return result;
    }
}
```



## **Python Code:**

```python
class Solution:
    def rotateTheBox(self, box: List[List[str]]) -> List[List[str]]:
        rows, cols = len(box), len(box[0])

        result = [['.'] * rows for _ in range(cols)]

        for i in range(rows):
            empty_spot = cols - 1  
            for j in range(cols - 1, -1, -1):
                if box[i][j] == '#':

                    box[i][j], box[i][empty_spot] = '.', '#'
                    empty_spot -= 1
                elif box[i][j] == '*':

                    empty_spot = j - 1

            for j in range(cols):
                result[j][rows - 1 - i] = box[i][j]

        return result
```


## **Rust Code:**

```rust
impl Solution {
    pub fn rotate_the_box(r#box: Vec<Vec<char>>) -> Vec<Vec<char>> {
        let rows = r#box.len();
        let cols = r#box[0].len();
        let mut result = vec![vec!['.'; rows]; cols];

        for i in 0..rows {
            let mut empty_spot = cols - 1;
            for j in (0..cols).rev() {
                if r#box[i][j] == '#' {
                    result[empty_spot][rows - 1 - i] = '#';
                    empty_spot -= 1;
                } else if r#box[i][j] == '*' {
                    result[j][rows - 1 - i] = '*';
                    empty_spot = j - 1;
                }
            }
        }

        result
    }
}
```

# 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).


## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:25px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
